'****************************************************************
'*  Name    : LCD CLOCK driven by WIFI module                                      *
'*  Author  : Les Kerr                   *
'*  
'*  Date    : 20-May-17                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
' Program to display returned value (12Hr clock) at Ashby of a WIFI module on RB2
' 
' LCD should be connected as follows:
' LCD PIC
' DB4 PortA.0
' DB5 PortA.1
' DB6 PortA.2
' DB7 PortA.3
' RS PortA.4 (add 4.7K pullup resistor to 5 volts)
' E PortB.3
' RW Ground
' Vdd 5 volts
' Vss Ground
' Vo 20K potentiometer (or ground)
' DB0-3 No connect
'GPS sentence: $GPRMC,192144.62,A,5041.6058,N,00412.6124,E,0.45,3 57.74,081205,,*0B

   #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC
 #ENDCONFIG                                                                                                                                        
 
 
   
 '  __config _XT_OSC & _WDT_OFF & _PWRTE_ON & _MCLRE_OFF & _BODEN_ON & _LVP_OFF & _CP_OFF
                                                                                                                                         
 
define OSC 20   'oscillator 20MHz        
 define LCD_DREG PORTA'PORTA is LCD data PORT
    define LCD_DBIT 0 'PORTA.0 is the data lowest significanr bit  
    define LCD_RSREG PORTA   ' PORTA - RS port   
    define LCD_RSBIT 4       ' RS bit connects to PORTA.4
    define LCD_EREG PORTB ' PORTB E PORT
    define LCD_EBIT 3    ' E to RB3
    Define LCD_BITS 4 '4 data lines used
    define LCD_LINES 2  'The LCD display that is used is 1 line 16 character
    'To make it work you have to treat it as a 2 line display. The first 8
    ' characters are written on the 1st line and the 2nd 8 on the 2nd line.
    Define LCD_COMMANDUS 3000 'Set command delay time to 3ms
    define LCD_DATAUS 150 'Set data delay to 150 micro second
   
CMCON = 7   'comparitors off
include "modedefs.bas"

GPSin VAR PORTB.2 ' GPS out connected to PORTB.2


TRISA = %00100000  ' all outputs except RA5
TRISB = %00000100  ' 'TRISB = %00000100
ANSEL = %00000000   ' all RA digital


'Allocate Variables for GPS: 
 
baudGPS CON 84 'driven non inverted no parity 9600 for 4800 change to 188
ss var byte  'seconds
hh var byte  'hours
UTChh VAR BYTE 'UTC hours
mm VAR BYTE 'minutes
d VAR BYTE 'day
m VAR BYTE 'month
y VAR BYTE 'year
UTCd var byte 'UTC date
UTCm var byte 'UTC month
UTCy var byte 'UTC year
fix VAR WORD 'GPS fix
ndm var byte 'no of days in month
a var byte 'A=1 when UTChh = 14 and 0 when UTChh = 0 used for adjusting date
x var byte ' year divide by 4 ie leap year
e var byte 'end date of daylight saving
s var byte ' start date of daylight saving
Z var byte ' daylight saving signal 1 on zero off
dy var word ' day no in year of current month
dyt var word ' day no in for current month a no days in month
hy var word' hour no in year of current time
dys var word 'day no start daylight saving
dye var byte 'day no end daylight saving 
hys var word 'hour in year no when daylight saving starts
hye var word 'hour in year no when daylight saving ends
y4d var word ' 4 digit value of year 
P var byte 'am PM

hh=0
UTChh=00
mm=00
ss=00 
d=0
UTCd = 00
UTCm = 00
UTCy = 00
m=0
y=0 
ndm = 0
x = 0
e = 0
s = 0
y4d = 0
dy = 0
Dyt= 0
hy = 0
dys = 0
dye = 0
hys = 0
hye = 0
PORTB.6 = 0 
P = 0


GPS: 'start of GPS

 SerIn2 GPSin,baudGPS,[wait("$GPRMC"),wait(","),DEC2 UTChh,DEC2 mm,dec2 ss,wait(","),fix,skip 31,wait(","),DEC2 UTCd,DEC2 UTCm,DEC2 UTCy] 'skip all characters between UTC time and date

y4d = 2000 + UTCy  'calculate year to 4 digits. 

e = 7 -(4 + (5*y4d/4))//7'calculate the day of the week for the end date of daylight saving
s = e - 1
if s = 0 then s = 7
ndm = 28+ (UTCm + (UTCm/8))//2 + 2//UTCm + 2*(1/UTCm)  ' formula to determine the no of days in the month when you enter the month
 X = UTCy//4   ' divide the year by 4 to check for leap year
 if X > 0 and ndm = 28 then ndm = 28  ' when not a leap year leave february at 28days
 if X = 0 and ndm = 28 then ndm = ndm + 1 ' when a leap year advance february days by 1
 'day of year calculation
 if UTCm = 1 then dy = 0  'Jan
 If UTCm = 2 then dy = 31 'Feb
 if UTCm = 3 then dy = 59 ' Mar
 If UTCM = 4 then dy = 90 ' April
 if UTCm = 5 then dy = 120 'May
 if UTCm = 6 then dy = 151 'Jun
 if UTCm = 7 then Dy = 181 'Jul
 if UTCm = 8 then dy = 212 'Aug
 if UTCm = 9 then dy = 243 'Sep
 if UTCm = 10 then dy = 273 'Oct
 if UTCm = 11 then dy = 304 'Nov
 If UTCM = 12 then dy = 334 'Dec
 if X = 0 and UTCm > 2 then dy = dy + 1' if a leap year the day of year advanced by 1
 ' Daylight saving starts in Australia on s day in October ie for 2017 it starts on
 '1st October at 2 am. This equates to UTC time 30 September (previous day) at 16:00 and calculates to6568 hours from the begging of the year 2017
 'it ends at e day in April at 3am ie for 2017 it ended on the 2nd April UTC time 17:00 hr previous day ie 1st April. which calculates to 2201 hours from year start
 dyt = dy + UTCd ' days to the month plus days in month
 if ((s - 1) = 0) and (X > 0) then dys = 273' If start date is the 1stOct then previous day is 30Sep, no leap year
 if ((s - 1) => 1) and (x > 0) then dys = 272 + s  'if start date is greater than 1 then the previous day is used , no leap year
 if ((s - 1) = 0) and (X = 0) then dys = 274 ' leap year advanced by 1 day
 if ((s - 1) => 1) and (x = 0) then dys = 273 + s ' leap year advanced by 1 day
 hys = (dys * 24) + 16  ' hours in year of daylight saving start time (for 1st October 2017 = (274 * 12) + 16 = 3304
 
 if ((e - 1) = 0) and (x > 0) then dye = 90' If end date is the 1st April then previous day is 30th mar
 if ((e - 1) => 1) and (x > 0)then dye = 89 + e 'if start date is greater than 1 then the previous day is used
 if ((e - 1) = 0) and (x = 0) then dye = 91 ' leap year advanced by 1 day
 if ((e - 1) => 1) and (x = 0)then dye = 90 + e ' leap year advanced by 1 day
 hye = (dye * 24) + 16  ' hours in year of daylight saving start time
 
 hy =  (dyt * 24) + UTChh
 
 If hy < hye then portB.6 = 1' daylight saving and LED ON
 if hy => hye and hy < hys then PORTB.6 = 0 ' no daylight saving LED off
 if hy => hys then PORTB.6 = 1 'dayligt saving and LED on
 'end of day of year calc
 
If UTChh >= 14 and UTChh < 24 then a = 1' a = 1 between 12 midnight australian time and 9am australian time
If UTChh => 0 and UTCHH <14 then a = 0 ' a = 0 between 10 am australian time and 11pm australian time 

Yearadj:
If a = 1 then goto Yeart
if a = 0 then goto Yeart2
Yeart:
if UTCm = 12 then y = UTCy + 1  ' add 1 year to UTC year if time is between 12 midnight australian time and 9am australian time and the month is 12 
'if (UTCm = 12) and (UTCd = 31) then y = UTCy + 1 ' add 1 year to UTC year if time is between 12 midnight australian time and 9am australian time and the month is 12 and day 31  
if UTCm < 12 then  y = UTCy
Goto Monthadj
Yeart2:
y = UTCy    ' display  UTC year if time is between 10 am australian time and 11pm australian time 
goto Monthadj
Monthadj:
If a = 1 and (UTCd = ndm) then goto Montha
if a = 0 and (UTCd = ndm) then goto Montha2
if a = 1 and (UTCd < ndm) then goto Montha2
if a = 0 and (UTCd < ndm) then goto Montha2
Montha:
IF UTCM < 12 then m = UTCm + 1 ' add 1 month to UTC month if time is between 12 midnight australian time and 9am australian time and not the l2th month
if UTCm = 12 then m = 1 'reset month if it is the last day of the month
goto Dayadj
Montha2:
m = UTCm  ' display  UTC month if time is between 10 am australian time and 11pm australian time
goto Dayadj



Dayadj:
if a = 1 then goto Dayt
if a = 0 then goto Dayt2
Dayt:
 

 if UTCd = ndm then d = 1' If it is the last day in the month the reset the day to 1
 If UTCd < ndm then  d = UTCd + 1 ' add 1 day to UTC day if time is between 12 midnight australian time and 9am australian time and its not the last day in the month
  goto Hourt   

 Dayt2: 
 
 d =UTCd ' display  UTC day if time is between 10 am australian time and 11pm australian time 
 goto HourT
 

HourT:
If PORTB.6 = 0 then goto HourT1  'if no daylight saving goto hourT1
if PORTB.6 = 1 then goto HourT2 'if daylight saving goto hour T2
HourT2:
If (UTChh >=1) and (UTChh <= 22) then goto TIME1A

if UTChh = 0 then goto TIME2A
if UTChh = 23 then goto TIME3A
TIME1A:
UTChh = UTChh + 1
goto HourT1
TIME2A:
UTChh = 1
goto HourT1
TIME3A:
UTChh = 0
goto HourT1
HourT1:
if (UTChh >=15) and (UTChh<=23) Then
GOTO TIME1
endif
if UTChh = 0 or UTChh = 1 then
  goto TIME2
  endif
  if UTChh = 2 then 
  goto TIME3
  endif
   if (UTChh =>3) and (UTChh <= 13) then
  goto TIME4
  endif
   if UTChh = 14 then
  goto  Time5
  endif
  goto GPS
TIME1:
hh = UTChh - 14
goto Dis
DIS: 


  LCDOUT $FE,$01  'clear display
  LCDOUT $FE,$80   ' move cursor to first line of display  
  lcdout "  TIME ",dec2 hh,":",dec2 mm,":",dec2 ss
  LCDout $FE,$C0  'move cursor to second line
  LCDout "  DATE ",DEC2 d,"-",DEC2 m,"-",DEC2 y
  goto GPS
  
 
  
  
  goto GPS
 
  TIME2:     
  hh = UTChh + 10
  goto DIS
  
  TIME3:
  hh = UTChh + 10
  goto DIS2
  DIS2:
 
 
  LCDOUT $FE,$01  'clear display
  LCDOUT $FE,$80   ' move cursor to first line of display  
  lcdout "  TIME ",dec2 hh,":",dec2 mm,":",dec2 ss 
  LCDout $FE,$C0  'move cursor to second line     
  LCDout "  DATE ",DEC2 d,"-",DEC2 m,"-",DEC2 y 
  goto GPS
  
  
 
  
  
  TIME4:
  hh = UTChh - 2  
  goto DIS2 
   TIME5:
  hh = UTChh - 2
  goto DIS
